package openrtb3

type Media struct {
	Ad      *Ad         `json:"ad,omitempty"`
	Secure  int         `json:"secure,omitempty"`
	Display *DisplayRes `json:"display,omitempty"`
	Video   *VideoRes   `json:"video,omitempty"`
	Audio   *AudioRes   `json:"audio,omitempty"`
}

type Ad struct {
	ID      string   `json:"id,omitempty"`
	Adomain []string `json:"adomain,omitempty"`
	Cat     []string `json:"cat,omitempty"`
	Lang    string   `json:"lang,omitempty"`
	Attr    []int    `json:"attr,omitempty"`
}

type DisplayRes struct {
	Ctype  []int      `json:"ctype,omitempty"`
	Adm    string     `json:"adm,omitempty"`
	Event  *EventRes  `json:"event,omitempty"`
	Native *Nativeres `json:"native,omitempty"`
}

type Nativeres struct {
	Asset []Assetval `json:"asset,omitempty"`
	Link  *Link      `json:"link,omitempty"`
}

type Assetval struct {
	Id       int       `json:"id"`
	Required int       `json:"required,omitempty"`
	Title    *TitleRes `json:"title,omitempty"`
	Img      string    `json:"img,omitempty"`
	W        int       `json:"w,omitempty"`
	H        int       `json:"h,omitempty"`
	Video    *VideoRes `json:"video,omitempty"`
	Adm      string    `json:"adm,omitempty"`
	Data     string    `json:"data,omitempty"`
	Link     *Link     `json:"link,omitempty"`
}

type TitleRes struct {
	Text string `json:"text,omitempty"`
}

type Link struct {
	Url  string   `json:"url,omitempty"`
	Trkr []string `json:"trkr,omitempty"`
}

type EventRes struct {
	Type   int    `json:"type,omitempty"`
	Method int    `json:"method,omitempty"`
	URL    string `json:"url,omitempty"`
}

type VideoRes struct {
	Dur   int    `json:"dur,omitempty"`
	Adm   string `json:"adm,omitempty"`
	Curl  string `json:"curl,omitempty"`
	Api   []int  `json:"api,omitempty"`
	Ctype []int  `json:"ctype,omitempty"`
}

type AudioRes struct {
	Dur   int    `json:"dur,omitempty"`
	Adm   string `json:"adm,omitempty"`
	Curl  string `json:"curl,omitempty"`
	Api   []int  `json:"api,omitempty"`
	Ctype []int  `json:"ctype,omitempty"`
}
